//------------------------------------------------------------------------------------
//
//     Arduino Fixture Controller Using Ethernet TCPIP Control
//
//------------------------------------------------------------------------------------
#include <SPI.h>
#include <Ethernet.h>
#include <avr/wdt.h>

// Enter a MAC address and IP address for your controller below.
// The IP address will be dependent on your local network.
// gateway and subnet are optional:
byte mac[] = {
  0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
IPAddress ip(192, 168, 1, 1);
IPAddress myDns(192, 168, 1, 1);
IPAddress gateway(192, 168, 1, 1);
IPAddress subnet(255, 255, 255, 0);

// telnet defaults to port 23
EthernetServer server(23);
boolean alreadyConnected = false; // whether or not the client was connected previously

// client
EthernetClient client;

void setup() {

  // initialize the ethernet device
  Ethernet.begin(mac, ip, myDns, gateway, subnet);

  // Open serial communications for debug purposes
  Serial.begin(9600);

  // Check for Ethernet hardware present
  if (Ethernet.hardwareStatus() == EthernetNoHardware) {
    Serial.println("Ethernet shield was not found.  Sorry, can't run without hardware. :(");
  }
  if (Ethernet.linkStatus() == LinkOFF) {
    Serial.println("Ethernet cable is not connected.");
  }

  // start listening for clients
  server.begin();

  // Report address
  Serial.print("Address:");
  Serial.println(Ethernet.localIP());

  // Set digital lines
  pinMode(2, OUTPUT);

  // Enable watchdog timer with 2 second timeout
  wdt_enable(WDTO_2S);
}

void loop() {
  
  // wait for a new client:
  client = server.available();

  // check if client is connected
  if (client) {

    // check for command byte
    if (client.available() > 0) {
      byte command = client.read();
      if (command == 'A') client.print("Arduino");
      if (command == 'B') setDigital();
    }
  }

  // Reset watchdog timer
  wdt_reset();
}

void setDigital() {
  
  // Wait for one byte of data
  wdt_reset();
  do {} while(client.available() < 1);
  byte data = client.read();

  // Set port
  if (data=='0') { digitalWrite(2, LOW); Serial.println("Low"); }
  if (data=='1') { digitalWrite(2, HIGH); Serial.println("High"); }

  // Reply
  client.print("B");
}
